ORCA/M Asm65816 2.1.0

0001 8A52              **********************************************************************
0002 8A52              *
0003 8A52              * Patch to Misc.Tools
0004 8A52              * For ROM 3.0
0005 8A52              *
0006 8A52              * Copyright 1985-1992
0007 8A52              * Apple Computer, Inc.
0008 8A52              * All Rights Reserved
0009 8A52              *
0010 8A52              **********************************************************************
0011 8A52              *
0012 8A52              * 17-Sep-90         Dave Lyons
0013 8A52              *
0014 8A52              * Changed version number to $8302 for 6.0.
0015 8A52              * Fixed ConvSeconds to return carry clear on no error, and to return
0016 8A52              *   an error when convVerb is too big by one.
0017 8A52              * Added SysBeep2 skeleton.
0018 8A52              *
0019 8A52              * 1-Oct-90          Dave Lyons
0020 8A52              *
0021 8A52              * Finished SysBeep2.  Added the actual call to _SendRequest.
0022 8A52              *
0023 8A52              * 16-Oct-90         Dave Lyons
0024 8A52              *
0025 8A52              * Strip off bit 15 of the SysBeep2 parameter when sending it to
0026 8A52              * SendRequest.  It's just a flag specifying whether to beep if
0027 8A52              * nobody accepts the request.
0028 8A52              *
0029 8A52              * 5-Dec-90          Dave Lyons
0030 8A52              *
0031 8A52              * Added VersionString call to convert 32-bit version numbers into
0032 8A52              * strings (12.3.4d56).
0033 8A52              *
0034 8A52              * 11-Dec-90         Dave Lyons
0035 8A52              *
0036 8A52              * Changed definition of Stage field in VersionString version number.
0037 8A52              * "Final" is now distinct from "released."
0038 8A52              *
0039 8A52              * 6-Jan-91          Dave Lyons
0040 8A52              *
0041 8A52              * Added WaitUntil call for maxxing out the speed of repeated user-
0042 8A52              * visible actions (like continuous scrolling, zoom-rect effects,
0043 8A52              * menu item blinking, and control blinking).
0044 8A52              *
0045 8A52              * 9-Jan-91          Dave Lyons
0046 8A52              *
0047 8A52              * Made WaitUntil multiply the delay by BRAM $60 minus 1, unless the
0048 8A52              * location is $00 or $FF (defaults for ROM 1 and ROM 3).  The wait
0049 8A52              * maxxes out at $F00 ticks (64 seconds).
0050 8A52              *
0051 8A52              * 11-Feb-91         Dave Lyons
0052 8A52              *
0053 8A52              * Implemented bit 14 in SysBeep2 (defers the request until the next
0054 8A52              * GetNextEvent which allows mouse presses or keypresses).
0055 8A52              *
0056 8A52              * 14-Feb-91         Dave Lyons
0057 8A52              *
0058 8A52              * Made bit 14 in SysBeep2 do nothing if the Event Manager isn't started.
0059 8A52              *
0060 8A52              * 16-Feb-91         Dave Lyons
0061 8A52              *
0062 8A52              * Patched GetROMResource so I can easily override the ChooseFont
0063 8A52              * resources.  (I could just put them in Sys.Resources, but this way
0064 8A52              * I can continue using pointers within the resources.)
0065 8A52              *
0066 8A52              * 4-Mar-91          Dave Lyons
0067 8A52              *
0068 8A52              * Added new call StringToText to translate "Shaston 8" style text into
0069 8A52              * text-display text, with or without mousetext.  Total RAM about 1.25K.
0070 8A52              *
0071 8A52              * 9-Mar-91          Dave Lyons
0072 8A52              *
0073 8A52              * A SysBeep2 call with the defer-till-GNE bit set is now ignored if
0074 8A52              * there is already one pending.
0075 8A52              *
0076 8A52              * 29-Mar-91         Dave Lyons
0077 8A52              *
0078 8A52              * Added new calls ScanDevices and ShowBootInfo.
0079 8A52              *
0080 8A52              * 1-Apr-91          Dave Lyons
0081 8A52              *
0082 8A52              * Added 2 scanlines to the top of the area that FillScreenBottom
0083 8A52              * fills with $DDDD when we are about to run off the right edge.
0084 8A52              *
0085 8A52              * 2-Apr-91          Dave Lyons
0086 8A52              *
0087 8A52              * Change ShowBootInfo to draw to the Text screen or SHR screen,
0088 8A52              * but not both.  Fix first-time-here logic accordingly.
0089 8A52              *
0090 8A52              * 14-Apr-91         Dave Lyons
0091 8A52              *
0092 8A52              * Change StringToText so that if the source text is contained in
0093 8A52              * the result buffer, I make a separate copy of the source text
0094 8A52              * before processing.  This is partly for the benefit of ProDOS
0095 8A52              * JudgeName.
0096 8A52              *
0097 8A52              * Added a ResultFlags parameter to StringToText so the caller
0098 8A52              * can tell if any changes were made to the string.
0099 8A52              *
0100 8A52              * 6-May-91          Dave Lyons
0101 8A52              *
0102 8A52              * Added parnoia check to ShowBootInfo so an icon can't get drawn
0103 8A52              * past the bottom of the screen.
0104 8A52              *
0105 8A52              * 9-May-91          Dave Lyons
0106 8A52              *
0107 8A52              * Fixed lots of error handling in ConvSeconds.  Implemented the
0108 8A52              * cool ProDOS 8 year scheme.
0109 8A52              *
0110 8A52              * 20-May-91         Dave Lyons
0111 8A52              *
0112 8A52              * Setting bit 31 of the iconPtr to ShowBootInfo makes it re-use
0113 8A52              * the previous position (the icon that overprints it ought to be
0114 8A52              * the same width!).
0115 8A52              *
0116 8A52              * Patched SysFailMgr to enable text page 1 shadowing.
0117 8A52              *
0118 8A52              * Changed ConvSeconds FromProDOS (verb 5) so it doesn't trash the
0119 8A52              * input buffer.  Verb 11 (HC to Seconds) restores the input buffer.
0120 8A52              *
0121 8A52              * 2-Jul-91          Dave Lyons
0122 8A52              *
0123 8A52              * In ShowBootInfo, added check for bit 1 of BRAM location $5F.  If
0124 8A52              * set, we don't draw the icon.
0125 8A52              *
0126 8A52              * SysBeep2 now sends to Apple~SoundCP~ before broadcasting the request.
0127 8A52              *
0128 8A52              * 8-Jul-91          Dave Lyons
0129 8A52              *
0130 8A52              * ShowBootInfo now does nothing if QuickDraw is started (in case some
0131 8A52              * DA or CDev gets initialized at some time other than boot time).
0132 8A52              * Also, bit 31 of the string pointer makes ShowBootInfo reinitialize
0133 8A52              * itself.  (This happens at DeskStartUp time.)
0134 8A52              *
0135 8A52              * 22-Aug-91         Dave Lyons
0136 8A52              *
0137 8A52              * ShowBootInfo now prints a CR after printing a text string.
0138 8A52              *
0139 8A52              * 17-Sep-91         Dave Lyons
0140 8A52              *
0141 8A52              * Link some stuff into Tool.Setup instead of TS2/3.  Routines moved
0142 8A52              * are:  UnPackBytes, ConvSeconds, SysBeep2, VersionString, WaitUntil,
0143 8A52              * StringToText, ShowBootInfo, ScanDevices.
0144 8A52              *
0145 8A52              * 14-Oct-91         Dave Lyons
0146 8A52              *
0147 8A52              * Made StringToText return a reasonable length when possible even if
0148 8A52              * it returns error $034F, buffer too small.
0149 8A52              *
0150 8A52              * 1-Nov-91          Dave Lyons
0151 8A52              *
0152 8A52              * Made MTBootInit zap E1/0196 and E1/0197, so that ReadMouse will
0153 8A52              * return a valid Status byte.
0154 8A52              *
0155 8A52              * 16-Jan-92         Dave Lyons
0156 8A52              *
0157 8A52              * StringToText:  Changed translation of German "" ($A7) to "ss".
0158 8A52              * Made some optimizations, including making the translate table
0159 8A52              * entries 5 bytes each instead of 6.  Added 32 new translations
0160 8A52              * per Yvan Koenig.
0161 8A52              *
0162 8A52              * 21-Jan-92         Dave Lyons
0163 8A52              *
0164 8A52              * StringToText:  Fixed flags on the -->ss translation to show
0165 8A52              * that it's a lengthening translation.
0166 8A52              *
0167 8A52              * 27-Jan-92         Dave Lyons
0168 8A52              *
0169 8A52              * Added ToBramSetupPatch (sets bank to $00 around call).
0170 8A52              *
0171 8A52              * 30-Jan-92         Dave Lyons
0172 8A52              *
0173 8A52              * Fixed a problem in UnPackBytes where a %10xxxxxx packet was not
0174 8A52              * correctly checking the remaining space in the output buffer (it
0175 8A52              * was off by a factor of two).
0176 8A52              *
0177 8A52              * 5-Feb-92          Dave Lyons
0178 8A52              *
0179 8A52              * Version $0302 for 6.0 final.
0180 8A52              *
0181 8A52              * 6-Feb-92          Dave Lyons
0182 8A52              *
0183 8A52              * Oops, fixed bad compare in StringToText (introduced 16-Jan).
0184 8A52              *
0185 8A52              **********************************************************************
0186 8A52              *
0187 8A52              * Begin 6.0.1
0188 8A52              *
0189 8A52              * 12-Mar-92         Dave Lyons
0190 8A52              *
0191 8A52              * Version $8303.
0192 8A52              *
0193 8A52              * Make ShowBootInfo start a new row (higher) if the first one fills up.
0194 8A52              *
0195 8A52              * 23-Jun-92         Dave Lyons
0196 8A52              *
0197 8A52              * SysFailMgr now has better default messages for errors $0027 and $0201.
0198 8A52              *
0199 8A52              * 1-Jul-92          Dave Lyons
0200 8A52              *
0201 8A52              * Added message for SysFailMgr errors $0308, $0681, $0682.
0202 8A52              *
0203 8A52              * 18-Jul-92         Dave Lyons
0204 8A52              *
0205 8A52              * Made SysBeep2 send systemSaysForceUndim ($000D), for all codes except
0206 8A52              * $006x (screen blanking, screen unblanking).
0207 8A52              *
0208 8A52              * 20-Aug-92         Dave Lyons
0209 8A52              *
0210 8A52              * New calls AlertMessage and DoSysPrefs.
0211 8A52              *
0212 8A52              * 1-Oct-92          Dave Lyons for 6.0.1d11
0213 8A52              *
0214 8A52              * DoSysPrefs result is the *old* prefs value, not the new one.
0215 8A52              *
0216 8A52              * 22-Oct-92         Dave Lyons for 6.0.1d12
0217 8A52              *
0218 8A52              * DoSysPrefs returns error $0301 (and a random result) if GS/OS
0219 8A52              * is not the active operating system.
0220 8A52              *
0221 8A52              * 2-Apr-93 DAL
0222 8A52              *
0223 8A52              * Version $0303 for 6.0.1.
0224 8A52              *
0225 8A52              **********************************************************************
0226 8A52
0227 8A52                       entry MTInit 
0228 8A52                       entry MTVer 
0229 8A52                       entry GetAddr 
0230 8A52                       entry ConvSeconds 
0231 8A52                       entry SysBeep2                 ;17-Sep-90 DAL
0232 8A52                       entry UnPackBytes              ;23-Oct-90 DAL
0233 8A52                       entry VersionString            ;5-Dec-90 DAL
0234 8A52                       entry WaitUntil                ;6-Jan-91 DAL
0235 8A52                       entry GetROMResource           ; 16-Feb-91 DAL
0236 8A52                       entry StringToText             ;4-Mar-91 DAL
0237 8A52                       entry ScanDevices              ;29-Mar-91 DAL
0238 8A52                       entry ShowBootInfo             ;29-Mar-91 DAL
0239 8A52                       entry NewSysFail               ;20-May-91 DAL
0240 8A52
0241 8A52              MTVersionNumber equ   $0303             ;2-Apr-93 DAL
0242 8A52
0243 8A52                       include ':::sys.equs.asm' 
0244 8A52                       include 'all.macros' 
0245 8A52
0246 8A52              PendingSysBeep2 equ   $E1167E
0247 8A52
0248 8A52              MTCallTable PROC EXPORT 
0249 8A52
0250 8A52              Here      
0251 8A52 40 00 00 00           DC L:(TheEnd-Here)/4           ; num calls +1
0252 8A56 5B 8E 02 00           DC L:MTInit-1                  ; PowerUp Initialization
0253 8A5A 00 00 00 00           DC L:0                         ; application startup
0254 8A5E 00 00 00 00           DC L:0                         ; application shutdown
0255 8A62 51 8E 02 00           DC L:MTVer-1                   ; version number
0256 8A66 00 00 00 00           DC L:0                         ; Misc. Tools Reset
0257 8A6A 00 00 00 00           DC L:0                         ; MTStatus
0258 8A6E 00 00 00 00           DC L:0                         ; Reserved
0259 8A72 00 00 00 00           DC L:0                         ; Reserved
0260 8A76 00 00 00 00           DC L:0                         ; Write battery ram
0261 8A7A 00 00 00 00           DC L:0                         ; Read battery ram
0262 8A7E 00 00 00 00           DC L:0                         ; Write battery ram parameter
0263 8A82 00 00 00 00           DC L:0                         ; Read battery ram parameter
0264 8A86 00 00 00 00           DC L:0                         ; read clock w/ hex format
0265 8A8A 00 00 00 00           DC L:0                         ; write clock w/ hex format
0266 8A8E 00 00 00 00           DC L:0                         ; read clock w/ ascii format
0267 8A92 00 00 00 00           DC L:0                         ; set interrupt vector
0268 8A96 00 00 00 00           DC L:0                         ; get interrupt vector
0269 8A9A 00 00 00 00           DC L:0                         ; insert procedure in Heartbeat chain
0270 8A9E 00 00 00 00           DC L:0                         ; delete procedure from heartbeat chai
0271 8AA2 00 00 00 00           DC L:0                         ; clear heartbeat chain
0272 8AA6 64 8E 02 00           DC L:NewSysFail-1              ; system death manager (patched 20-May-91 DAL)
0273 8AAA 82 8F 02 00           DC L:GetAddr-1                 ;  ???
0274 8AAE 00 00 00 00           DC L:0                         ; Read Mouse
0275 8AB2 00 00 00 00           DC L:0                         ; initialize mouse
0276 8AB6 00 00 00 00           DC L:0                         ; set mouse mode
0277 8ABA 00 00 00 00           DC L:0                         ; home mouse position to min. clamp
0278 8ABE 00 00 00 00           DC L:0                         ; clear mouse position to 0
0279 8AC2 00 00 00 00           DC L:0                         ; set both X and Y clamps
0280 8AC6 00 00 00 00           DC L:0                         ; get both X and Y clamps
0281 8ACA 00 00 00 00           DC L:0                         ; set mouse position
0282 8ACE 00 00 00 00           DC L:0                         ; service mouse interrupt
0283 8AD2 00 00 00 00           DC L:0                         ; get ID tag
0284 8AD6 00 00 00 00           DC L:0                         ; delete ID tag
0285 8ADA 00 00 00 00           DC L:0                         ; get ID tag status
0286 8ADE 00 00 00 00           DC L:0                         ; enable interrupt source
0287 8AE2 00 00 00 00           DC L:0                         ; Firmware entry points
0288 8AE6 00 00 00 00           DC L:0                         ; get tick counter contents
0289 8AEA 00 00 00 00           DC L:0                         ; Pack bytes
0290 8AEE 00 00 00 00           DC L:0                         ;[ts] UnPackBytes-1   ; UnPack dem dere bytes
0291 8AF2 00 00 00 00           DC L:0                         ; This routine munges strings
0292 8AF6 00 00 00 00           DC L:0                         ; returns IRQ enble status
0293 8AFA 00 00 00 00           DC L:0                         ; set absolute device clamps
0294 8AFE 00 00 00 00           DC L:0                         ; get absolute device clamps
0295 8B02 00 00 00 00           DC L:0                         ; 2C03 system beep
0296 8B06
0297 8B06 00 00 00 00           DC L:0                         ; 2D03 NewBasicInit   ; added 07 sep 88
0298 8B0A
0299 8B0A 00 00 00 00           DC L:0                         ; 2E03 AddToQueue     ; added 10 sep 88
0300 8B0E 00 00 00 00           DC L:0                         ; 2F03 RemoveFromQueue ; added 10 sep 88
0301 8B12 00 00 00 00           DC L:0                         ; 3003 SetInterruptState added 24 Nov 88
0302 8B16 00 00 00 00           DC L:0                         ; 3103 GetInterruptState added 24 Nov 88
0303 8B1A 00 00 00 00           DC L:0                         ; 3203 GetIntStateRecSize added 24 Nov 88
0304 8B1E
0305 8B1E 00 00 00 00           DC L:0                         ; 3303 ReadMouse2 Added 13 Jan 89
0306 8B22 00 00 00 00           DC L:0                         ; 3403 GetCodeResConverter added 13 Jan 89 {$3403}
0307 8B26 EB 8F 02 00           DC L:GetROMResource-1          ; 3503 GetROMResource added 24 Jan 89 ($3503}
0308 8B2A 00 00 00 00           DC L:0                         ; 3603 ReleaseROMResource added 24 Jan 89 {$3603}
0309 8B2E              *** 5.0.3
0310 8B2E 00 00 00 00           DC L:0                         ;[ts] ConvSeconds-1   ; 3703 added 3/14/90
0311 8B32              *** 6.0
0312 8B32 00 00 00 00           DC L:0                         ;[ts] SysBeep2-1      ; 3808 added 17-Sep-90 DAL
0313 8B36 00 00 00 00           DC L:0                         ;[ts] VersionString-1 ;3903 added 5-Dec-90 DAL
0314 8B3A 00 00 00 00           DC L:0                         ;[ts] WaitUntil-1     ; 3A03 added 6-Jan-91 DAL
0315 8B3E 00 00 00 00           DC L:0                         ;[ts] StringToText-1  ; 3B03 added 3-Mar-91 DAL
0316 8B42 00 00 00 00           DC L:0                         ;[ts] ShowBootInfo-1  ; 3C03 added 29-Mar-91 DAL
0317 8B46 00 00 00 00           DC L:0                         ;[ts] ScanDevices-1   ; 3D03 added 29-Mar-91 DAL
0318 8B4A              *** 6.0.1
0319 8B4A 00 00 00 00           DC L:0                         ;[ts] AlertMessage-1  ; 3E03 added 20-Aug-92 DAL
0320 8B4E 00 00 00 00           DC L:0                         ;[ts] DoSysPrefs-1    ; 3F03 added 20-Aug-92 DAL
0321 8B52              TheEnd    
0322 8B52
0323 8B52                       ENDP 
0324 8B52
0325 8B52              ****************************************************************
0326 8B52              *
0327 8B52              MTVer    Proc 
0328 8B52              *
0329 8B52              * Returns new version number
0330 8B52              *
0331 8B52              *
0332 8B52              * Inputs:
0333 8B52              *                   none
0334 8B52              *
0335 8B52              * Outputs:
0336 8B52              *                   VersionNumber : word
0337 8B52              *
0338 8B52              * External Refs:
0339 8B52              *                   none
0340 8B52              *
0341 8B52              * Entry Points:
0342 8B52              *                   none
0343 8B52              *
0344 8B52                       longa on                       ; mode
0345 8B52                       longi on
0346 8B52              *
0347 8B52              ****************************************************************
0348 8B52
0349 8B52 A9 03 03              lda   #MTVersionNumber
0350 8B55 83 07                 sta   7,s
0351 8B57
0352 8B57 A9 00 00              lda   #0
0353 8B5A 18                    clc   
0354 8B5B 6B                    rtl   
0355 8B5C
0356 8B5C                       ENDP 
0357 8B5C
0358 8B5C
0359 8B5C
0360 8B5C              ****************************************************************
0361 8B5C              *
0362 8B5C              MTInit   PROC 
0363 8B5C              *
0364 8B5C              * Dummy Init routine prevents real init routine from being
0365 8B5C              * called twice when this patch is installed.
0366 8B5C              *
0367 8B5C              *
0368 8B5C              * Inputs:
0369 8B5C              *                   none
0370 8B5C              *
0371 8B5C              * Outputs:
0372 8B5C              *                   none
0373 8B5C              *
0374 8B5C              * External Refs:
0375 8B5C              *
0376 8B5C              * Entry Points:
0377 8B5C              *                   none
0378 8B5C              *
0379 8B5C                       longa on                       ; mode
0380 8B5C                       longi on
0381 8B5C              *
0382 8B5C              ****************************************************************
0383 8B5C
0384 8B5C A9 00 00              lda   #0
0385 8B5F              *** added 1-Nov-91 DAL -- zero out mouse mode byte, since ReadMouse
0386 8B5F              ***  is returning some garbage.
0387 8B5F 8F 96 01 E1           sta   >$E10196                 ;zap MseStat and MseMode
0388 8B63              *** end 1-Nov-91 DAL
0389 8B63
0390 8B63 18                    clc                            ;A is still zero
0391 8B64 6B                    rtl   
0392 8B65
0393 8B65                       ENDP 
0394 8B65
0395 8B65
0396 8B65              ****************************************************************
0397 8B65              *
0398 8B65              * NewSysFail -- ROM 03 patch for SysFailMgr (20-May-91 DAL)
0399 8B65              *
0400 8B65              * One fix to the ROM:  Enable text page 1 shadowing.
0401 8B65              *
0402 8B65              ****************************************************************
0403 8B65              NewSysFail proc 
0404 8B65                       import ComputeDefaultFailMsg 
0405 8B65
0406 8B65 20 77 8E              jsr   ComputeDefaultFailMsg    ;23-Jun-92 DAL
0407 8B68
0408 8B68 AF 35 C0 E0           lda   >$e0c035
0409 8B6C 29 FE FF              and   #$fffe
0410 8B6F 8F 35 C0 E0           sta   >$e0c035
0411 8B73 5C 3C B0 FE           jml   >$feb03c
0412 8B77
0413 8B77                       EndP 
0414 8B77
0415 8B77              ****************************************************************
0416 8B77              *
0417 8B77              * ComputeDefaultFailMsg -- 23-Jun-92 DAL
0418 8B77              *
0419 8B77              * Called from SysFailMgr.  If the supplied string pointer is
0420 8B77              * NIL (for "Fatal System Error " string) then use special
0421 8B77              * messages for common error codes.
0422 8B77              *
0423 8B77              * The stack looks like this:
0424 8B77              *
0425 8B77              * 13-14:  error number
0426 8B77              *  9-12:  message pointer
0427 8B77              *   6-8:  RTL
0428 8B77              *   3-5:  RTL
0429 8B77              *   1-2:  RTS address
0430 8B77              *
0431 8B77              ****************************************************************
0432 8B77              ComputeDefaultFailMsg proc export  
0433 8B77
0434 8B77              @msg     equ   9
0435 8B77              @error   equ   13
0436 8B77
0437 8B77 A3 09                 lda   @msg,s
0438 8B79 03 0B                 ora   @msg+2,s
0439 8B7B D0 1E                 bne   @cantTouchMe
0440 8B7D
0441 8B7D A3 0D                 lda   @error,s
0442 8B7F 8F 9C 8E 02           sta   >codeTable
0443 8B83 A2 0C 00              ldx   #msgTable-codeTable
0444 8B86 CA           @search  dex   
0445 8B87 CA                    dex   
0446 8B88 DF 9C 8E 02           cmp   >codeTable,x
0447 8B8C D0 F8                 bne   @search
0448 8B8E
0449 8B8E BF A8 8E 02           lda   >msgTable,x
0450 8B92 83 09                 sta   @msg,s
0451 8B94 F0 05                 beq   @stillNIL
0452 8B96 A9 02 00              lda   #ComputeDefaultFailMsg>>16
0453 8B99 83 0B                 sta   @msg+2,s
0454 8B9B              @stillNIL  
0455 8B9B
0456 8B9B 60           @cantTouchMe rts   
0457 8B9C
0458 8B9C 77 77 27 00  codeTable DC W:$7777,$0027,$0201,$0308,$0681,$0682
0459 8BA8 00 00 B4 8E  msgTable DC W:$0000,ioError,outOfMemory,trashError,trashError,trashError
0460 8BB4
0461 8BB4 40           ioError  DC B:ioErrorEnd-ioError-1
0462 8BB5 43 6F 75 6C           DC B:'Could not read or write disk.  The disk',13
0463 8BDD 6D 61 79 20           DC B:'may be damaged.  Error $'
0464 8BF5              ioErrorEnd  
0465 8BF5
0466 8BF5 44           outOfMemory DC B:oomEnd-outOfMemory-1
0467 8BF6 4F 75 74 20           DC B:'Out of memory (or required memory area',13
0468 8C1D 77 61 73 20           DC B:'was already in use).  Error $'
0469 8C3A              oomEnd    
0470 8C3A
0471 8C3A 48           trashError DC B:trashEnd-trashError-1
0472 8C3B 44 65 74 65           DC B:'Detected trashed memory--software bug',13
0473 8C61 6F 72 20 28           DC B:'or (less likely) bad RAM.  Error $'
0474 8C83              trashEnd  
0475 8C83
0476 8C83                       EndP 
0477 8C83
0478 8C83
0479 8C83                       title 'GetAddress' 
0480 8C83              ****************************************************************
0481 8C83              *
0482 8C83              * Return Interrupt Status Address
0483 8C83              *
0484 8C83              * Input     word         refnum
0485 8C83              * Input     LongWord     Don't care
0486 8C83              *
0487 8C83              * Output    LongWord     Pointer
0488 8C83              *
0489 8C83              * Modification History
0490 8C83              *
0491 8C83              *    May 6, 1986    See 5 lines changed below.
0492 8C83              *
0493 8C83              ****************************************************************
0494 8C83              GetAddr  PROC 
0495 8C83              ROMGetAddr equ   $FEB04B
0496 8C83              ROMoEndCall2 equ   $FEFBF7
0497 8C83              RTL1     equ   1
0498 8C83              RTL2     equ   RTL1+3
0499 8C83              RefNum   equ   RTL2+3
0500 8C83              Ptr      equ   RefNum+2
0501 8C83
0502 8C83 A3 07                 lda   RefNum,s                 ; get ref #
0503 8C85 C9 FF 00              cmp   #$00FF                   ; index our special address? ?
0504 8C88 F0 04                 beq   GetAddrSerial            ;
0505 8C8A 5C 4B B0 FE           jml   ROMGetAddr               ; 
0506 8C8E
0507 8C8E              GetAddrSerial                           ; 
0508 8C8E AA                    tax                            ; get param. addr
0509 8C8F AF 9F 8F 02           lda   >Ptbl                    ; abs long,x addressing SEG 6 May 86
0510 8C93 83 09                 sta   Ptr,s
0511 8C95 AF A1 8F 02           lda   >Ptbl+2                  ; abs long,x addressing SEG 6 May 86
0512 8C99 83 0B                 sta   Ptr+2,s                  ; missing +2 SEG 6 May 86
0513 8C9B 5C F7 FB FE           jml   ROMoEndCall2             ; uses oEndCall SEG 6 May 86
0514 8C9F
0515 8C9F              Ptbl                                    ;
0516 8C9F D8 1D E1 00           DC L:$E11dd8                   ; status of INTFLAG at IRQ
0517 8CA3              PtblEnd                                 ;
0518 8CA3
0519 8CA3                       ENDP 
0520 8CA3
0521 8CA3
0522 8CA3              *****************************************************************
0523 8CA3              *
0524 8CA3              * NewSysBeep
0525 8CA3              *
0526 8CA3              * The new sysbeep routine.  This routine calls the old sysbeep
0527 8CA3              * routine if the volume is not set to zero and flashes the
0528 8CA3              * border when it is set to zero.
0529 8CA3              *
0530 8CA3              * Inputs:  None
0531 8CA3              * Outputs: CLC if we completely handled the necessary beeping
0532 8CA3              * all registers preserved
0533 8CA3              * Called in any native mode--mode preserved.
0534 8CA3              *
0535 8CA3              *****************************************************************
0536 8CA3              OrigBellVector proc Export 
0537 8CA3 00 00 00 00           DC L:0
0538 8CA7                       ENDP 
0539 8CA7
0540 8CA7                       EXPORT NewSysBeep 
0541 8CA7              NewSysBeep PROC 
0542 8CA7 DA                    phx                            ; preserve <X> and <Y> & <A> inside this routine
0543 8CA8 5A                    phy   
0544 8CA9 48                    pha   
0545 8CAA 08                    php                            ; save m and x
0546 8CAB E2 30                 sep   #$30                     ; 8 bit mode
0547 8CAD                       longa off
0548 8CAD                       longi off
0549 8CAD
0550 8CAD AF CA 00 E1           lda   >IRQ_Volume              ; look at the volume
0551 8CB1 29 0F                 and   #$0F
0552 8CB3 F0 31                 beq   ExitSEC                  ;the ROM can handle this already
0553 8CB5
0554 8CB5 AF 1E 03 E1           lda   >$e102c0+$5E
0555 8CB9 4A                    lsr   a
0556 8CBA B0 2A                 bcs   ExitSEC                  ;the ROM can handle this too (no special blink)
0557 8CBC AF CA 00 E1           lda   >IRQ_Volume
0558 8CC0 48                    pha   
0559 8CC1 A9 00                 lda   #0
0560 8CC3 8F CA 00 E1           sta   >IRQ_Volume
0561 8CC7 8B                    phb   
0562 8CC8 F4 E1 E1              pea   $e1e1
0563 8CCB AB                    plb   
0564 8CCC AB                    plb   
0565 8CCD 4B                    phk   
0566 8CCE 62 08 00              per   @returnHere-1
0567 8CD1 F4 82 00              pea   $0083-1                  ;there's an RTL at $FF/0083
0568 8CD4 E2 30                 sep   #$30
0569 8CD6 5C 58 9A FF           jml   >$ff9a58                 ;ROM code will blink because volume=0
0570 8CDA AB           @returnHere plb   
0571 8CDB E2 30                 sep   #$30
0572 8CDD 68                    pla   
0573 8CDE 8F CA 00 E1           sta   >IRQ_Volume
0574 8CE2 8F 3C C0 E1           sta   >$e1c03c
0575 8CE6
0576 8CE6 28           ExitSEC  plp                            ; nonzero so set carry and get out
0577 8CE7 68                    pla   
0578 8CE8 7A                    ply                            ; restore <X> and <Y> & <A> here
0579 8CE9 FA                    plx   
0580 8CEA 38                    sec   
0581 8CEB 6B                    rtl   
0582 8CEC
0583 8CEC                       longa on
0584 8CEC                       longi on
0585 8CEC
0586 8CEC                       ENDP 
0587 8CEC
0588 8CEC
0589 8CEC              *******************************************************************************
0590 8CEC              *
0591 8CEC              GetROMResource PROC EXPORT 
0592 8CEC              *
0593 8CEC              * Description:      This call will return a 'handle' to the data requested by the
0594 8CEC              *                   ROM routine. This will either be a fake handle that exists
0595 8CEC              *                   only in ROM, or a real resource loaded from disk. The tool
0596 8CEC              *                   should not treat this resouce any different from a handle, 
0597 8CEC              *                   except that it is always to be treated as read only. The 
0598 8CEC              *                   parameters of this call are identical to those of the
0599 8CEC              *                   real resource manager. Please refer to then for further 
0600 8CEC              *                   details.
0601 8CEC              *
0602 8CEC              *
0603 8CEC              * Inputs:           On Stack
0604 8CEC              *                   |  previous contents  |
0605 8CEC              *                   +---------------------+
0606 8CEC              *                   |                     |
0607 8CEC              *                   +--    LongSpace    --+ LONG Room for result
0608 8CEC              *                   |                     |
0609 8CEC              *                   +---------------------+
0610 8CEC              *                   |   resource type     | WORD Type of resource to find
0611 8CEC              *                   +---------------------+
0612 8CEC              *                   |                     |
0613 8CEC              *                   +--   resource ID   --+ LONG ID of resource to load
0614 8CEC              *                   |                     |
0615 8CEC              *                   +---------------------+
0616 8CEC              *                   |                     | <- SP
0617 8CEC              *
0618 8CEC              *
0619 8CEC              *
0620 8CEC              * Outputs:          On Stack
0621 8CEC              *                   |  previous contents  |
0622 8CEC              *                   +---------------------+
0623 8CEC              *                   |                     |
0624 8CEC              *                   +--   Data Handle   --+ LONG Handle to data storage
0625 8CEC              *                   |                     |
0626 8CEC              *                   +---------------------+
0627 8CEC              *                   |                     | <- SP
0628 8CEC              *
0629 8CEC              *
0630 8CEC              * Errors:           Memory manager errors
0631 8CEC              *                   $0310   Requested data does not exist
0632 8CEC              *                           This can only happen if a ROM version of the data
0633 8CEC              *                           does not already exist.
0634 8CEC              *
0635 8CEC              * External Refs:
0636 8CEC              *
0637 8CEC              * Entry Points:
0638 8CEC              *
0639 8CEC              *******************************************************************************
0640 8CEC              *
0641 8CEC              * Patched for ROM 3 16-Feb-91 DAL so I can replace the Font Manager resources
0642 8CEC              * but keep using the other ones from ROM.
0643 8CEC              *
0644 8CEC              *******************************************************************************
0645 8CEC                       import w320start,w640start     ;from ChooseFontStuff in misc tools ROMDataMgr
0646 8CEC              ;
0647 8CEC              ; Equates for use with our stack frame...
0648 8CEC              SaveDPage equ   1
0649 8CEC              RetAddr1 equ   SaveDPage+2
0650 8CEC              RetAddr2 equ   RetAddr1+3
0651 8CEC              resID    equ   RetAddr2+3
0652 8CEC              ResType  equ   ResID+4
0653 8CEC              result   equ   resType+2
0654 8CEC
0655 8CEC 0B                    phd                            ; save the current dpage
0656 8CED 3B                    tsc                            ; get the stack pointer
0657 8CEE 5B                    tcd                            ; and make it the direct page...
0658 8CEF
0659 8CEF 64 0F                 stz   <result                  ; first zero out the result
0660 8CF1 64 11                 stz   <result+2
0661 8CF3
0662 8CF3              ;
0663 8CF3              ; Since this tool is going to work with the resource manager, we will first 
0664 8CF3              ; test to see if the resource manager is running with the status call
0665 8CF3
0666 8CF3 F4 00 00              pea   $0000                    ; room for result
0667 8CF6 A2 1E 06 22           _ResourceStatus 
0668 8CFD 68                    pla   
0669 8CFE F0 20                 beq   UseROMData               ; if this is false, use the ROM data
0670 8D00
0671 8D00              ;
0672 8D00              ; If the resource manager is running, try to load the resource that we want.
0673 8D00
0674 8D00 48                    pha                            ; room for result
0675 8D01 48                    pha   
0676 8D02 A5 0D                 lda   <ResType                 ; type of resource to load
0677 8D04 48                    pha   
0678 8D05 A5 0B                 lda   <ResID+2                 ; ID of resource to load
0679 8D07 48                    pha   
0680 8D08 A5 09                 lda   <ResID
0681 8D0A 48                    pha   
0682 8D0B A2 1E 0E 22           _Loadresource                  ;attempt to load the resource from the file
0683 8D12 68                    pla                            ; get the result for a second...
0684 8D13 FA                    plx   
0685 8D14 B0 0A                 bcs   UseROMData               ; if an error occured, us the ROM resource
0686 8D16              ;
0687 8D16              ; If we get this far then we have loaded the resource from the resource file,
0688 8D16              ; and we should just return its handle to the caller...
0689 8D16
0690 8D16 85 0F                 sta   <result                  ; store the result in result
0691 8D18 86 11                 stx   <result+2
0692 8D1A A0 00 00              ldy   #0                       ; error code ...
0693 8D1D 82 4B 00              brl   GRRDone                  ; and end the call
0694 8D20
0695 8D20              ;
0696 8D20              UseROMData  
0697 8D20              ; This routine will be called when the apropriate resource is not available, it will
0698 8D20              ; look thru the ROM data tables and pick out the proper handle from the list. If it
0699 8D20              ; can not find a proper resource in the list, it will simply bomb with a data not
0700 8D20              ; found error
0701 8D20
0702 8D20 A2 00 00              ldx   #0                       ; init our counter
0703 8D23 BF 6F 90 02  FindLoop lda   >TypeList,x              ; load in the first type
0704 8D27 C5 0D                 cmp   <resType                 ; does it match our desired id?
0705 8D29 D0 12                 bne   tryNext                  ; if not, try the next one
0706 8D2B BF 71 90 02           lda   >IDList,x                ; next try the ID list
0707 8D2F C5 09                 cmp   <ResID                   ; see if the ID matches
0708 8D31 D0 0A                 bne   tryNext                  ; if not try the next one
0709 8D33 BF 73 90 02           lda   >IDList+2,x              ; now the high byte of the ID
0710 8D37 C5 0B                 cmp   <ResID+2
0711 8D39 D0 02                 bne   tryNext
0712 8D3B 80 1C                 bra   FoundROMData             ; if all tests match, then we found the ROM data
0713 8D3D              tryNext   
0714 8D3D BF 6F 90 02           lda   >TypeList,x              ; test to see if we are at the end of the list
0715 8D41 1F 71 90 02           ora   >IDList,x                ; by finding 0's in the type and ID field
0716 8D45 1F 73 90 02           ora   >IDList+2,x
0717 8D49 F0 08                 beq   NoROMData                ; if this is zero, then there is no ROM data
0718 8D4B 8A                    txa                            ; bump our counter
0719 8D4C 18                    clc   
0720 8D4D 69 0A 00              adc   #SizeofEntry             ; by the size of each entry
0721 8D50 AA                    tax                            ; and try the next one...
0722 8D51 80 D0                 bra   FindLoop
0723 8D53              NoROMData  
0724 8D53              ;
0725 8D53              ; This routine places an error into Y and ends
0726 8D53 A0 10 03              ldy   #$0310                   ; data not found error
0727 8D56 82 12 00              brl   GRRDone
0728 8D59
0729 8D59              FoundROMData  
0730 8D59              ;
0731 8D59              ; This routine sets up the proper result and returns it to the caller.
0732 8D59 8A                    txa                            ; put table offset into <A>
0733 8D5A 18                    clc                            ; and create a pointer to our pointer
0734 8D5B 69 75 90              adc   #HandleTbl
0735 8D5E 85 0F                 sta   <Result
0736 8D60 A9 00 00              lda   #0
0737 8D63 69 02 00              adc   #HandleTbl>>16
0738 8D66 85 11                 sta   <Result+2
0739 8D68 A0 00 00              ldy   #0
0740 8D6B              ;
0741 8D6B              GRRDone   
0742 8D6B              ; This routine moves the return address on the stack and then tests <Y> for an
0743 8D6B              ; error code, and returns.
0744 8D6B
0745 8D6B 5C 98 D8 FD           jml   >$fdd898                 ;back into ROM
0746 8D6F
0747 8D6F
0748 8D6F              SizeofEntry  equ   10
0749 8D6F
0750 8D6F FF FF        TypeList DC W:$FFFF                     ; first resource is a sample...
0751 8D71 01 00 00 00  IDList   DC L:1                         ; please don't remove...
0752 8D75 75 90 02 00  HandleTbl DC L:HandleTbl                ; sampleData
0753 8D79
0754 8D79              ; Entry for Font Manager ChooseFont templates here!
0755 8D79 0E 80                 DC W:$800E                     ; resource Type
0756 8D7B 01 1B FF 0F           DC L:$0FFF1B01                 ; font manager window #1
0757 8D7F A1 90 02 00           DC L:w320Start                 ; from misc tools ROMDataMgr ChooseFontStuff
0758 8D83
0759 8D83 0E 80                 DC W:$800E                     ; res type
0760 8D85 02 1B FF 0F           DC L:$0FFF1B02                 ; font manager window #2
0761 8D89 31 91 02 00           DC L:w640Start                 ; from misc tools ROMDataMgr ChooseFontStuff
0762 8D8D
0763 8D8D              ; Entry for Event manager
0764 8D8D              ; Default ID is now $FF instead of $01
0765 8D8D 21 80                 DC W:$8021                     ; res Type Ktrans table
0766 8D8F FF 06 FF 0F           DC L:$0FFF06FF                 ; ID Number
0767 8D93 BB D6 FD 00           DC L:$00FDD6BB                 ; default ktrans table in ROM 3
0768 8D97              ;
0769 8D97              ; END OF ID TABLE: DO NOT MODIFY THIS NEXT RECORD
0770 8D97 00 00                 DC W:$0000
0771 8D99 00 00 00 00           DC L:$00000000
0772 8D9D 00 00 00 00           DC L:$00000000
0773 8DA1
0774 8DA1                       EndP 
0775 8DA1
0776 8DA1
0777 8DA1                       END   
